<!-- begin:: Subheader -->
<div class="kt-subheader kt-grid__item" id="kt_subheader">
    <div class="kt-container kt-container--fluid">
        <div class="kt-subheader__main">
            <div class="kt-subheader__breadcrumbs">
                <a class="kt-subheader__breadcrumbs-link">Leads</a>
                <span class="kt-subheader__breadcrumbs-separator"></span>
                <a class="kt-subheader__breadcrumbs-link">Add Lead</a>
                <span class="kt-subheader__breadcrumbs-separator"></span>
            </div>
        </div>
    </div>
</div>

<div class="kt-container kt-container--fluid kt-grid__item kt-grid__item--fluid">
   <div class="kt-portlet">
      <div class="kt-portlet__body kt-portlet__body--fit">
         <div class="kt-grid kt-wizard-v1 kt-wizard-v1--white" id="kt_projects_add" data-ktwizard-state="first">
            <div class="kt-grid__item kt-grid__item--fluid kt-wizard-v1__wrapper">

               <form class="kt-form" id="kt_form" action="<?= base_url('leads/process_add_lead'); ?>" method="post">

                  <div class="kt-wizard-v1__content" data-ktwizard-type="step-content" data-ktwizard-state="current">
                     <div class="kt-heading kt-heading--md">Basic Information:</div>
                     <div class="kt-section kt-section--first">
                        <div class="kt-wizard-v1__form">
                           <div class="row">
                              <div class="col-xl-12">
                                 <div class="kt-section__body">

                                    <?php $validation = \Config\Services::validation(); ?>

                                    <div class="form-group row <?= $validation->hasError('full_name') ? 'has-error' : ''; ?>">
                                        <label class="col-xl-3 col-lg-3 col-form-label">Name <span class="required"> * </span></label>
                                        <div class="col-lg-9 col-xl-9">
                                            <input type="text" name="full_name" class="form-control input-height" value="<?= old('full_name'); ?>" required>
                                            <span class="help-block"><?= $validation->getError('full_name'); ?></span>
                                        </div>
                                    </div>

                                    <div class="form-group row <?= $validation->hasError('mobile') ? 'has-error' : ''; ?>">
                                        <label class="col-xl-3 col-lg-3 col-form-label">Mobile No. <span class="required"> * </span></label>
                                        <div class="col-lg-9 col-xl-9">
                                            <input type="text" name="mobile" maxlength="10" class="form-control input-height" value="<?= old('mobile'); ?>" required>
                                            <span class="help-block"><?= $validation->getError('mobile'); ?></span>
                                        </div>
                                    </div>

                                    <div class="form-group row <?= $validation->hasError('email') ? 'has-error' : ''; ?>">
                                        <label class="col-xl-3 col-lg-3 col-form-label">Email ID</label>
                                        <div class="col-lg-9 col-xl-9">
                                            <input type="text" name="email" class="form-control input-height" value="<?= old('email'); ?>">
                                            <span class="help-block"><?= $validation->getError('email'); ?></span>
                                        </div>
                                    </div>

                                    <?php $courses = get_courses(); ?>
                                    <div class="form-group row <?= $validation->hasError('course') ? 'has-error' : ''; ?>">
                                        <label class="col-xl-3 col-lg-3 col-form-label">Course <span class="required"> * </span></label>
                                        <div class="col-lg-9 col-xl-9">
                                            <select name="course" class="form-control input-height" required>
                                                <option value="">Choose Course</option>
                                                <?php foreach($courses as $value){ ?>
                                                    <option value="<?= $value['name']; ?>" <?= old('course') == $value['name'] ? 'selected' : ''; ?>>
                                                        <?= $value['name']; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                            <span class="help-block"><?= $validation->getError('course'); ?></span>
                                        </div>
                                    </div>

                                    <?php $state_list = get_state_list(); ?>
                                    <div class="form-group row <?= $validation->hasError('state') ? 'has-error' : ''; ?>">
                                        <label class="col-xl-3 col-lg-3 col-form-label">State <span class="required"> * </span></label>
                                        <div class="col-lg-9 col-xl-9">
                                            <select name="state" id="select_state" class="form-control input-height" required>
                                                <option value="">Choose State</option>
                                                <?php foreach($state_list as $value){ ?>
                                                    <option value="<?= $value['state']; ?>" <?= old('state') == $value['state'] ? 'selected' : ''; ?>>
                                                        <?= $value['state']; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                            <span class="help-block"><?= $validation->getError('state'); ?></span>
                                        </div>
                                    </div>

                                    <?php $city_list = get_city_by_state(old('state')); ?>
                                    <div class="form-group row <?= $validation->hasError('city') ? 'has-error' : ''; ?>">
                                        <label class="col-xl-3 col-lg-3 col-form-label">City <span class="required"> * </span></label>
                                        <div class="col-lg-9 col-xl-9">
                                            <select name="city"  id="select_city" class="form-control input-height" required>
                                                <option value="">Choose City</option>
                                                <?php foreach($city_list as $value){ ?>
                                                    <option value="<?= $value['city_name']; ?>" <?= old('city') == $value['city_name'] ? 'selected' : ''; ?>>
                                                        <?= $value['city_name']; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                            <span class="help-block"><?= $validation->getError('city'); ?></span>
                                        </div>
                                    </div>

                                    <?php $lead_source = get_lead_source_list(); ?>
                                    <div class="form-group row <?= $validation->hasError('lead_source') ? 'has-error' : ''; ?>">
                                        <label class="col-xl-3 col-lg-3 col-form-label">Lead Source</label>
                                        <div class="col-lg-9 col-xl-9">
                                            <select name="lead_source" class="form-control input-height">
                                                <option value="">Choose Lead Source</option>
                                                <?php foreach($lead_source as $value){ ?>
                                                    <option value="<?= $value['name']; ?>" <?= old('lead_source') == $value['name'] ? 'selected' : ''; ?>>
                                                        <?= $value['name']; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                            <span class="help-block"><?= $validation->getError('lead_source'); ?></span>
                                        </div>
                                    </div>

                                    <?php if(session()->get('user_id') == 1){ ?>
                                    <?php $user = get_user_by_parent_id(session()->get('user_id')); ?>
                                    <div class="form-group row <?= $validation->hasError('assigned_to') ? 'has-error' : ''; ?>">
                                        <label class="col-xl-3 col-lg-3 col-form-label">Assigned To <span class="required"> * </span></label>
                                        <div class="col-lg-9 col-xl-9">
                                            <select name="assigned_to" class="form-control input-height" required>
                                                <option value="">Choose Assigned To</option>
                                                <?php foreach($user as $value){ ?>
                                                    <option value="<?= $value['uid']; ?>" <?= old('assigned_to') == $value['uid'] ? 'selected' : ''; ?>>
                                                        <?= $value['name']; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                            <span class="help-block"><?= $validation->getError('assigned_to'); ?></span>
                                        </div>
                                    </div>
                                    <?php } ?>

                                    <div class="form-group row <?= $validation->hasError('remarks') ? 'has-error' : ''; ?>">
                                        <label class="col-xl-3 col-lg-3 col-form-label">Remarks</label>
                                        <div class="col-lg-9 col-xl-9">
                                            <textarea name="remarks" class="form-control input-height" required><?= old('remarks'); ?></textarea>
                                            <span class="help-block"><?= $validation->getError('remarks'); ?></span>
                                        </div>
                                    </div>

                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>

                  <div class="kt-form__actions">
                     <button type="submit" class="btn btn-brand btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-next">
                        Submit
                     </button>
                  </div>

               </form>

            </div>
         </div>
      </div>
   </div>
</div>