<?php

if (!function_exists('get_state_list')) {
    function get_state_list()
    {
        $AdminModel = new \App\Models\AdminModel();
        return $AdminModel->get_state_list();
    }
}

if (!function_exists('get_city_list')) {
    function get_city_list()
    {
        $AdminModel = new \App\Models\AdminModel();
        return $AdminModel->get_city_list();
    }
}

if (!function_exists('get_city_by_id')) {
    function get_city_by_id($id)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery = $AdminModel->get_city_by_id($id);
        if ($rowquery) {
            return $rowquery[0]['city_name'];
        }
    }
}

if (!function_exists('get_country_list')) {
    function get_country_list()
    {
        $AdminModel = new \App\Models\AdminModel();
        return $AdminModel->get_country_list();
    }
}

if (!function_exists('get_city_by_state')) {
    function get_city_by_state($state)
    {
        $AdminModel = new \App\Models\AdminModel();
        return $AdminModel->get_city_by_state($state);
    }
}

if (!function_exists('checkNull')) {
    function checkNull($value)
    {
        if ($value == null) {
            return '';
        } else {
            return $value;
        }
    }
}

if (!function_exists('getDatesFromRange')) {
    function getDatesFromRange($start, $end, $format = 'Y-m-d')
    {
        $array    = [];
        $interval = new DateInterval('P1D');
        $realEnd  = new DateTime($end);
        $realEnd->add($interval);
        $period = new DatePeriod(new DateTime($start), $interval, $realEnd);
        foreach ($period as $date) {
            $array[] = $date->format($format);
        }
        return $array;
    }
}

if (!function_exists('get_events_by_id')) {
    function get_events_by_id($id)
    {
        $AdminModel = new \App\Models\AdminModel();
        return $AdminModel->get_events_by_id($id);
    }
}

if (!function_exists('showCalendar')) {
    function showCalendar($month = NULL, $year = NULL)
    {
        $num          = cal_days_in_month(CAL_GREGORIAN, $month, $year);
        $dates_month  = [];
        for ($i = 1; $i <= $num; $i++) {
            $mktime = mktime(0, 0, 0, $month, $i, $year);
            $date   = date("d-M-Y", $mktime);
            $week   = 'week' . (int) date('W', $mktime);
            $dates_month[$week][date('D', $mktime)] = date("d", $mktime);
        }
        return $dates_month;
    }
}

if (!function_exists('get_courses')) {
    function get_courses()
    {
        $AdminModel = new \App\Models\AdminModel();
        return $AdminModel->get_courses();
    }
}

if (!function_exists('get_courses_by_id')) {
    function get_courses_by_id($id)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_courses_by_id($id);
        if ($rowquery) {
            return $rowquery[0]['name'];
        }
    }
}

if (!function_exists('get_sub_courses_by_id')) {
    function get_sub_courses_by_id($id)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_sub_courses_by_id($id);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('sub_course_by_courseid')) {
    function sub_course_by_courseid($id)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->sub_course_by_courseid($id);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_center_by_id')) {
    function get_center_by_id($id)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_center_by_id($id);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_pendency')) {
    function get_pendency($id)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_pendency($id);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_student_education')) {
    function get_student_education($id)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_student_education($id);
        if ($rowquery) {
            $finalArray = [];
            foreach ($rowquery as $key => $val) {
                $finalArray[$val['type']] = $val;
            }
            return $finalArray;
        }
    }
}

if (!function_exists('get_total_student')) {
    function get_total_student($uid, $year)
    {
        $ScriptModel = new \App\Models\ScriptModel();
        $rowquery    = $ScriptModel->total_student($uid, $year);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_total_enrolled_student')) {
    function get_total_enrolled_student($uid, $year)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_total_enrolled_student($uid, $year);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_center_last_uploaded')) {
    function get_center_last_uploaded($uid, $year)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_center_last_uploaded($uid, $year);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_total_submited_form')) {
    function get_total_submited_form($uid, $year)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_total_submited_form($uid, $year);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('center_total_fee')) {
    function center_total_fee($uid, $year)
    {
        $ScriptModel = new \App\Models\ScriptModel();
        $rowquery    = $ScriptModel->center_total_fee($uid, $year);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_total_student_by_course')) {
    function get_total_student_by_course($course_id, $year)
    {
        $ScriptModel = new \App\Models\ScriptModel();
        $rowquery    = $ScriptModel->get_total_student_by_course($course_id, $year);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_team_lead_center')) {
    function get_team_lead_center($user_name, $type = NULL)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_team_lead_center($user_name);
        if ($rowquery) {
            $centerArray = [];
            foreach ($rowquery as $key => $value) {
                $centerArray[] = $value['uid'];
            }
            if ($type == 'array') {
                return $centerArray;
            }
            if ($type == 'string') {
                $centerString = implode(",", $centerArray);
                return $centerString;
            }
        }
    }
}

if (!function_exists('get_user_by_parent_id')) {
    function get_user_by_parent_id($user_name)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_user_by_parent_id($user_name);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_counselor_list')) {
    function get_counselor_list()
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_counselor_list();
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_latest_news')) {
    function get_latest_news()
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_latest_news();
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('calender_wise_student')) {
    function calender_wise_student($calender_session)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->calender_wise_student($calender_session);
        if ($rowquery) {
            return $rowquery;
        } else {
            return 0;
        }
    }
}

if (!function_exists('get_center_received_amount')) {
    function get_center_received_amount($center_id)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_center_received_amount($center_id);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_center_details')) {
    function get_center_details($center_username)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_center_details($center_username);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_center_details_by_cname')) {
    function get_center_details_by_cname($cname)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_center_details_by_cname($cname);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_center_target')) {
    function get_center_target($cname, $session)
    {
        $ScriptModel = new \App\Models\ScriptModel();
        $rowquery    = $ScriptModel->get_center_target($cname, $session);
        if ($rowquery) {
            return $rowquery[0]['target'];
        }
    }
}

if (!function_exists('get_re_reg_total_student')) {
    function get_re_reg_total_student($uid, $year)
    {
        $ScriptModel = new \App\Models\ScriptModel();
        $rowquery    = $ScriptModel->get_re_reg_total_student($uid, $year);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('center_re_reg_total_fee')) {
    function center_re_reg_total_fee($uid, $year)
    {
        $ScriptModel = new \App\Models\ScriptModel();
        $rowquery    = $ScriptModel->center_re_reg_total_fee($uid, $year);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_counselor_by_email')) {
    function get_counselor_by_email($email)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_counselor_by_email($email);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_counselor_by_id')) {
    function get_counselor_by_id($id)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_counselor_by_id($id);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_user_name_list')) {
    function get_user_name_list()
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_user_name_list();
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_sub_center_by_id')) {
    function get_sub_center_by_id($user_id, $type = NULL)
    {
        $AdminModel = new \App\Models\AdminModel();
        $rowquery   = $AdminModel->get_sub_center_by_id($user_id);
        if ($rowquery) {
            $centerArray = [];
            foreach ($rowquery as $key => $value) {
                $centerArray[] = $value['uid'];
            }
            if ($type == 'array') {
                return $centerArray;
            }
            if ($type == 'string') {
                $centerString = implode(",", $centerArray);
                return $centerString;
            }
        }
    }
}

if (!function_exists('get_disposition')) {
    function get_disposition($dtype = NULL)
    {
        $LeadModel = new \App\Models\LeadModel();
        $rowquery  = $LeadModel->disposition_list($dtype);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_disposition_by_id')) {
    function get_disposition_by_id($id)
    {
        $LeadModel = new \App\Models\LeadModel();
        $rowquery  = $LeadModel->get_disposition_by_id($id);
        if ($rowquery) {
            return $rowquery;
        }
    }
}

if (!function_exists('get_lead_source_list')) {
    function get_lead_source_list()
    {
        $LeadModel = new \App\Models\LeadModel();
        $rowquery  = $LeadModel->get_lead_source_list();
        if ($rowquery) {
            return $rowquery;
        }
    }
}