<?php

namespace App\Controllers;

use App\Models\DatatableModel;

class Tables extends BaseController
{
    public function initController(
        \CodeIgniter\HTTP\RequestInterface $request,
        \CodeIgniter\HTTP\ResponseInterface $response,
        \Psr\Log\LoggerInterface $logger
    ) {
        parent::initController($request, $response, $logger);

        $this->DatatableModel = new DatatableModel();
    }

    public function student()
    {
        $student_details = $this->DatatableModel->make_data_table();
        $data = [];

        foreach ($student_details as $key) {
            $sub_array         = [];
            $user_type         = session()->get('user_type');
            $center_details    = get_center_by_id($key->user_id);
            $subCourse_details = get_sub_courses_by_id($key->sub_course_id);

            $action = '<a href="' . base_url() . 'admin/print_form/' . $key->id . '" class="btn btn-primary btn-xs" target="_blank"><i class="fa fa-eye"></i></a>';
            if ($user_type == 1 || $user_type == 2) {
                $action .= '<a href="' . base_url() . 'admin/edit_student/' . $key->id . '" class="btn btn-primary btn-xs" target="_blank"><i class="fa fa-pencil"></i></a>
			<a href="' . base_url() . 'admin/delete_student/' . $key->id . '" class="btn btn-danger btn-xs" style="margin-top: 5px;"><i class="fa fa-trash-o"></i></a>';
            }
            $sub_array[] = $action;

            if ($key->image != '') {
                $sub_array[] = '<img align="left" hspace="4" vspace="4"  height="70px" src="' . base_url() . 'uploads/' . $key->image . '" height="50"/>';
            } else {
                $sub_array[] = '';
            }

            $sub_array[] = ucfirst($key->id);

            if ($user_type == 1 || $user_type == 2) {
                if ($key->enroll_num) {
                    $sub_array[] = $key->enroll_num .
                        '<a class="sublink"  href="javascript:void(0);"   onclick = "openEnroll(' . $key->id . ')"><i class="fa fa-pencil"></i> Update</a>
				<a class="btn btn-danger btn-xs" href="javascript:void(0);"   onclick = "deleteEnroll(' . $key->id . ')"><i class="fa fa-trash-o "></i></a>';
                } else {
                    $sub_array[] = '<a class="sublink"  href="javascript:void(0);"   onclick = "openEnroll(' . $key->id . ')"><i class="fa fa-pencil"></i> Edit</a>';
                }
            } else {
                $sub_array[] = $key->enroll_num;
            }

            $form_status = '<span class="visited" id="loader_' . $key->id . '">';
            if ($user_type == 1 || $user_type == 2) {
                if (isset($key->form) && $key->form == '1') {
                    $checked = "checked";
                } else {
                    $checked = "";
                }
                $form_status .= '<input type="checkbox" name="form_status" value="1" id="checkstatus_' . $key->id . '" onclick = "checkstatus(' . $key->id . ')" ' . $checked . '>';
            }
            if (isset($key->form) && $key->form == '1') {
                $form_status .= $key->form_submited_date;
            }
            $form_status .= '</span><br/>';
            $sub_array[] = $form_status;

            $pendency_data = '<span class="visited" id="openPendency_' . $key->id . '">';
            $getPendency   = get_pendency($key->id);
            if ($user_type == 1 || $user_type == 2) {
                if ($getPendency[0]['pendency']) {
                    $pendency_data .= $getPendency[0]['pendency'];
                    $pendency_data .= '<a href="javascript:void(0)" class="sublink" onclick = "openPendency(' . $key->id . ')"  id="Pendency"><i class="fa fa-pencil"></i> Update</a>												
					<a class="btn btn-danger btn-xs"  href="javascript:void(0);"   onclick = "deletePendency(' . $key->id . ')"><i class="fa fa-trash-o "></i></a>';
                } else {
                    $pendency_data .= '<a href="javascript:void(0)" class="sublink" onclick = "openPendency(' . $key->id . ')"  id="Pendency"><i class="fa fa-pencil"></i> Click</a>';
                }
            } else {
                $pendency_data .= $getPendency[0]['pendency'];
            }
            $pendency_data .= '</span>';
            $sub_array[] = $pendency_data;

            $sub_array[] = ucfirst($key->name);
            $sub_array[] = ucfirst($key->father_name);
            $sub_array[] = ucfirst($key->mother_name);
            $sub_array[] = ucfirst($key->admission_session);
            $sub_array[] = ucfirst($key->admission_type);
            $sub_array[] = get_courses_by_id($key->course_id);
            $sub_array[] = $subCourse_details[0]['name'];
            $sub_array[] = $key->year;
            $sub_array[] = $center_details[0]['user_name'];
            $sub_array[] = $center_details[0]['company_name'];
            $sub_array[] = $key->center_ref_no;

            $data[] = $sub_array;
        }

        $output = [
            "draw"            => intval($this->request->getPost("draw")),
            "recordsTotal"    => $this->DatatableModel->get_all_data($this->request->getPost('year'), $this->request->getPost('type')),
            "recordsFiltered" => $this->DatatableModel->get_filtered_data($this->request->getPost('year'), $this->request->getPost('type')),
            "data"            => $data,
        ];

        echo json_encode($output);
    }

    public function re_reg_student()
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);

        $student_details = $this->DatatableModel->make_re_reg_data_table();
        $data = [];

        foreach ($student_details as $key) {
            $sub_array         = [];
            $user_type         = session()->get('user_type');
            $center_details    = get_center_by_id($key->user_id);
            $subCourse_details = get_sub_courses_by_id($key->sub_course_id);

            if ($key->image != '') {
                $sub_array[] = '<img align="left" hspace="4" vspace="4"  height="70px" src="' . base_url() . 'uploads/' . $key->image . '" height="50"/>';
            } else {
                $sub_array[] = '';
            }

            $sub_array[] = ucfirst($key->id);
            $sub_array[] = $key->enroll_num;
            $sub_array[] = $key->re_reg_date;
            $sub_array[] = ucfirst($key->name);
            $sub_array[] = ucfirst($key->father_name);
            $sub_array[] = ucfirst($key->mother_name);
            $sub_array[] = ucfirst($key->admission_session);
            $sub_array[] = ucfirst($key->admission_type);
            $sub_array[] = get_courses_by_id($key->course_id);
            $sub_array[] = $subCourse_details[0]['name'];
            $sub_array[] = $key->re_reg;
            $sub_array[] = $center_details[0]['company_name'];

            if ($user_type == 1 || $user_type == 2) {
                $action = '<a href="' . base_url() . 'admin/edit_student/' . $key->id . '" class="btn btn-primary btn-xs" target="_blank"><i class="fa fa-pencil"></i></a>
			<a href="' . base_url() . 'admin/delete_re_reg/' . $key->id . '" class="btn btn-danger btn-xs" style="margin-top: 5px;"><i class="fa fa-trash-o"></i></a>';
            } else {
                $action = '';
            }
            $sub_array[] = $action;

            $data[] = $sub_array;
        }

        $output = [
            "draw"            => intval($this->request->getPost("draw")),
            "recordsTotal"    => $this->DatatableModel->get_all_re_reg_data($this->request->getPost('year'), $this->request->getPost('type')),
            "recordsFiltered" => $this->DatatableModel->get_re_reg_filtered_data($this->request->getPost('year'), $this->request->getPost('type')),
            "data"            => $data,
        ];

        echo json_encode($output);
    }
}